/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;

public record ApplyMobEffect(HolderSet<MobEffect> toApply, LevelBasedValue minDuration, LevelBasedValue maxDuration, LevelBasedValue minAmplifier, LevelBasedValue maxAmplifier) implements EnchantmentEntityEffect
{
    public static final MapCodec<ApplyMobEffect> CODEC = RecordCodecBuilder.mapCodec(p_346379_ -> p_346379_.group((App)RegistryCodecs.homogeneousList(Registries.MOB_EFFECT).fieldOf("to_apply").forGetter(ApplyMobEffect::toApply), (App)LevelBasedValue.CODEC.fieldOf("min_duration").forGetter(ApplyMobEffect::minDuration), (App)LevelBasedValue.CODEC.fieldOf("max_duration").forGetter(ApplyMobEffect::maxDuration), (App)LevelBasedValue.CODEC.fieldOf("min_amplifier").forGetter(ApplyMobEffect::minAmplifier), (App)LevelBasedValue.CODEC.fieldOf("max_amplifier").forGetter(ApplyMobEffect::maxAmplifier)).apply((Applicative)p_346379_, ApplyMobEffect::new));

    @Override
    public void apply(ServerLevel p_345355_, int p_346112_, EnchantedItemInUse p_344766_, Entity p_345996_, Vec3 p_345315_) {
        LivingEntity $$5;
        RandomSource $$6;
        Optional<Holder<MobEffect>> $$7;
        if (p_345996_ instanceof LivingEntity && ($$7 = this.toApply.getRandomElement($$6 = ($$5 = (LivingEntity)p_345996_).getRandom())).isPresent()) {
            int $$8 = Math.round(Mth.randomBetween($$6, this.minDuration.calculate(p_346112_), this.maxDuration.calculate(p_346112_)) * 20.0f);
            int $$9 = Math.max(0, Math.round(Mth.randomBetween($$6, this.minAmplifier.calculate(p_346112_), this.maxAmplifier.calculate(p_346112_))));
            $$5.addEffect(new MobEffectInstance($$7.get(), $$8, $$9));
        }
    }

    public MapCodec<ApplyMobEffect> codec() {
        return CODEC;
    }
}

